/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.fw.util.Trace;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class Translator {
    private static final String TRACE_MASKT = "XFRMTRNT";
    private static final String TRACE_MASKF = "XFRMTRNF";
    private static final String TRACE_MASKD = "XFRMTRND";

    public static byte[] toCodePage(String text, String codePage) throws UnsupportedEncodingException {
        if (text == null) {
            text = "";
        }
        ByteArrayOutputStream translationStream = new ByteArrayOutputStream(text.length());
        try {
            if (codePage == null) {
                codePage = "Cp500";
            }
            OutputStreamWriter translationWriter = new OutputStreamWriter((OutputStream)translationStream, codePage);
            translationWriter.write(text);
            translationWriter.flush();
        }
        catch (UnsupportedEncodingException exc) {
            Trace.trace(TRACE_MASKF, "Error in toCodePage(text='" + text + "', codePage=" + codePage + ")");
            Trace.trace(TRACE_MASKF, exc);
            throw exc;
        }
        catch (IOException exc) {
            Trace.trace(TRACE_MASKF, "Error in toCodePage(text='" + text + "', codePage=" + codePage + ")");
            Trace.trace(TRACE_MASKF, exc);
        }
        return translationStream.toByteArray();
    }

    public static String fromCodePage(byte[] text, String codePage) throws UnsupportedEncodingException {
        String result = null;
        try {
            if (text == null) {
                text = new byte[]{};
            }
            if (codePage == null) {
                codePage = "Cp500";
            }
            result = new String(text, codePage);
        }
        catch (UnsupportedEncodingException exc) {
            Trace.trace(TRACE_MASKF, "Error in fromCodePage(text=" + text + ", codePage=" + codePage + ")");
            Trace.trace(TRACE_MASKF, exc);
            throw exc;
        }
        return result;
    }

    public static byte[] toEbcdic(String text) {
        byte[] result = null;
        try {
            result = Translator.toCodePage(text, "Cp500");
        }
        catch (UnsupportedEncodingException exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
        return result;
    }

    public static String fromEbcdic(byte[] text) {
        String result = "";
        try {
            result = Translator.fromCodePage(text, "Cp500");
        }
        catch (UnsupportedEncodingException exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
        return result;
    }

    public static byte[] toAscii(String text) {
        byte[] result = null;
        try {
            result = Translator.toCodePage(text, "US-ASCII");
        }
        catch (UnsupportedEncodingException exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
        return result;
    }

    public static byte[] toAsciiz(String text) {
        if (text == null) {
            text = "";
        }
        byte[] ascii = Translator.toAscii(text);
        byte[] result = new byte[ascii.length + 1];
        System.arraycopy(ascii, 0, result, 0, ascii.length);
        result[ascii.length] = 0;
        return result;
    }

    public static String fromAscii(byte[] text) {
        String result = "";
        try {
            result = Translator.fromCodePage(text, "US-ASCII");
        }
        catch (UnsupportedEncodingException exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
        return result;
    }

    public static String fromAsciiz(byte[] text) {
        String result = "";
        if (text != null) {
            int length = 0;
            while (length < text.length && text[length] != 0) {
                ++length;
            }
            if (length > 0) {
                byte[] ascii = new byte[length];
                System.arraycopy(text, 0, ascii, 0, ascii.length);
                result = Translator.fromAscii(ascii);
            }
        }
        return result;
    }

    private Translator() {
    }
}

